"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, cell_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about readiness of a Cell.

    Args:
        cell_name(str): The name of the Cell.
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.cell.readiness_summary.get(
                ctx, cell_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.cell.readiness_summary.get cell_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="get_cell_readiness_summary",
        op_kwargs={
            "CellName": cell_name,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
