"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, recovery_group_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of recommendations to improve resilliance and readiness check quality for a Recovery Group.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token that can be used to resume pagination from the end of the collection. Defaults to None.
        recovery_group_name(str): Name of RecoveryGroup (top level resource) to be analyzed.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.architecture_recommendation.get_all(
                ctx, recovery_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.architecture_recommendation.get_all recovery_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="get_architecture_recommendations",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "RecoveryGroupName": recovery_group_name,
        },
    )
