"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    assertion_rule: Dict = None,
    client_token: str = None,
    gating_rule: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a safety rule in a control panel. Safety rules let you add safeguards around enabling and disabling routing controls, to help prevent unexpected outcomes. There are two types of safety rules: assertion rules and gating rules. Assertion rule: An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted. Gating rule: A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.

    Args:
        assertion_rule(Dict, optional): A new assertion rule for a control panel. Defaults to None.
        client_token(str, optional): Unique client idempotency token. Defaults to None.
        gating_rule(Dict, optional): A new gating rule for a control panel. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.safety_rule.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.safety_rule.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="create_safety_rule",
        op_kwargs={
            "AssertionRule": assertion_rule,
            "ClientToken": client_token,
            "GatingRule": gating_rule,
        },
    )


async def delete(hub, ctx, safety_rule_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a safety rule./>

    Args:
        safety_rule_arn(str): The request body that you include when you update a safety rule.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.safety_rule.delete(
                ctx, safety_rule_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.safety_rule.delete safety_rule_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="delete_safety_rule",
        op_kwargs={"SafetyRuleArn": safety_rule_arn},
    )


async def describe(hub, ctx, safety_rule_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the safety rules (that is, the assertion rules and gating rules) for the routing controls in a control panel.

    Args:
        safety_rule_arn(str): The request body that you include when you update a safety rule.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.safety_rule.describe(
                ctx, safety_rule_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.safety_rule.describe safety_rule_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="describe_safety_rule",
        op_kwargs={"SafetyRuleArn": safety_rule_arn},
    )


async def list_all(
    hub, ctx, control_panel_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a control panel.

    Args:
        control_panel_arn(str): The Amazon Resource Name (ARN) of the control panel that you're getting details for.
        max_results(int, optional): The number of objects that you want to return with this call. Defaults to None.
        next_token(str, optional): The token that identifies which batch of results you want to see. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.safety_rule.list_all(
                ctx, control_panel_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.safety_rule.list_all control_panel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="list_safety_rules",
        op_kwargs={
            "ControlPanelArn": control_panel_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub, ctx, assertion_rule_update: Dict = None, gating_rule_update: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Update a safety rule (an assertion rule or gating rule) for the routing controls in a control panel. You can only update the name and the waiting period for a safety rule. To make other updates, delete the safety rule and create a new safety rule.

    Args:
        assertion_rule_update(Dict, optional): An update to an assertion rule. You can update the name or the evaluation period (wait period). If you don't specify one of the items to update, the item is unchanged. Defaults to None.
        gating_rule_update(Dict, optional): Update to a gating rule. You can update the name or the evaluation period (wait period). If you don't specify one of the items to update, the item is unchanged. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.safety_rule.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.safety_rule.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="update_safety_rule",
        op_kwargs={
            "AssertionRuleUpdate": assertion_rule_update,
            "GatingRuleUpdate": gating_rule_update,
        },
    )
