"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    cluster_arn: str,
    routing_control_name: str,
    client_token: str = None,
    control_panel_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new routing control. A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control traffic routing. To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.

    Args:
        client_token(str, optional): Unique client idempotency token. Defaults to None.
        cluster_arn(str): The Amazon Resource Name (ARN) of the cluster that includes the routing control.
        control_panel_arn(str, optional): The Amazon Resource Name (ARN) of the control panel that includes the routing control. Defaults to None.
        routing_control_name(str): The name of the routing control.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.routing_control.create(
                ctx, cluster_arn=value, routing_control_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.routing_control.create cluster_arn=value, routing_control_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="create_routing_control",
        op_kwargs={
            "ClientToken": client_token,
            "ClusterArn": cluster_arn,
            "ControlPanelArn": control_panel_arn,
            "RoutingControlName": routing_control_name,
        },
    )


async def delete(hub, ctx, routing_control_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a routing control.

    Args:
        routing_control_arn(str): The Amazon Resource Name (ARN) of the routing control that you're deleting.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.routing_control.delete(
                ctx, routing_control_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.routing_control.delete routing_control_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="delete_routing_control",
        op_kwargs={"RoutingControlArn": routing_control_arn},
    )


async def describe(hub, ctx, routing_control_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays details about a routing control. A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing. To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.

    Args:
        routing_control_arn(str): The Amazon Resource Name (ARN) of the routing control that you're getting details for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.routing_control.describe(
                ctx, routing_control_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.routing_control.describe routing_control_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="describe_routing_control",
        op_kwargs={"RoutingControlArn": routing_control_arn},
    )


async def list_all(
    hub, ctx, control_panel_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.

    Args:
        control_panel_arn(str): The Amazon Resource Name (ARN) of the control panel that you're getting routing control details for.
        max_results(int, optional): The number of objects that you want to return with this call. Defaults to None.
        next_token(str, optional): The token that identifies which batch of results you want to see. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.routing_control.list_all(
                ctx, control_panel_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.routing_control.list_all control_panel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="list_routing_controls",
        op_kwargs={
            "ControlPanelArn": control_panel_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(hub, ctx, routing_control_arn: str, routing_control_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates a routing control. You can only update the name of the routing control. To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.

    Args:
        routing_control_arn(str): The Amazon Resource Name (ARN) of the routing control.
        routing_control_name(str): The name of the routing control.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.routing_control.update(
                ctx, routing_control_arn=value, routing_control_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.routing_control.update routing_control_arn=value, routing_control_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="update_routing_control",
        op_kwargs={
            "RoutingControlArn": routing_control_arn,
            "RoutingControlName": routing_control_name,
        },
    )
