"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, cluster_arn: str, control_panel_name: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new control panel. A control panel represents a group of routing controls that can be changed together in a single transaction. You can use a control panel to centrally view the operational status of applications across your organization, and trigger multi-app failovers in a single transaction, for example, to fail over an Availability Zone or AWS Region.

    Args:
        client_token(str, optional): Unique client idempotency token. Defaults to None.
        cluster_arn(str): The Amazon Resource Name (ARN) of the cluster for the control panel.
        control_panel_name(str): The name of the control panel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.control_panel.create(
                ctx, cluster_arn=value, control_panel_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.control_panel.create cluster_arn=value, control_panel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="create_control_panel",
        op_kwargs={
            "ClientToken": client_token,
            "ClusterArn": cluster_arn,
            "ControlPanelName": control_panel_name,
        },
    )


async def delete(hub, ctx, control_panel_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a control panel.

    Args:
        control_panel_arn(str): The Amazon Resource Name (ARN) of the control panel that you're deleting.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.control_panel.delete(
                ctx, control_panel_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.control_panel.delete control_panel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="delete_control_panel",
        op_kwargs={"ControlPanelArn": control_panel_arn},
    )


async def describe(hub, ctx, control_panel_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays details about a control panel.

    Args:
        control_panel_arn(str): The Amazon Resource Name (ARN) of the control panel that you're getting details for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.control_panel.describe(
                ctx, control_panel_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.control_panel.describe control_panel_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="describe_control_panel",
        op_kwargs={"ControlPanelArn": control_panel_arn},
    )


async def list_all(
    hub, ctx, cluster_arn: str = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of control panels for a cluster.

    Args:
        cluster_arn(str, optional): The Amazon Resource Name (ARN) of a cluster. Defaults to None.
        max_results(int, optional): The number of objects that you want to return with this call. Defaults to None.
        next_token(str, optional): The token that identifies which batch of results you want to see. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.control_panel.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.control_panel.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="list_control_panels",
        op_kwargs={
            "ClusterArn": cluster_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(hub, ctx, control_panel_arn: str, control_panel_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates a control panel. The only update you can make to a control panel is to change the name of the control panel.

    Args:
        control_panel_arn(str): The Amazon Resource Name (ARN) of the control panel.
        control_panel_name(str): The name of the control panel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.control_panel.update(
                ctx, control_panel_arn=value, control_panel_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.control_panel.update control_panel_arn=value, control_panel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="update_control_panel",
        op_kwargs={
            "ControlPanelArn": control_panel_arn,
            "ControlPanelName": control_panel_name,
        },
    )
