"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, cluster_name: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Create a new cluster. A cluster is a set of redundant Regional endpoints against which you can run API calls to update or get the state of one or more routing controls. Each cluster has a name, status, Amazon Resource Name (ARN), and an array of the five cluster endpoints (one for each supported Amazon Web Services Region) that you can use with API calls to the Amazon Route 53 Application Recovery Controller cluster data plane.

    Args:
        client_token(str, optional): Unique client idempotency token. Defaults to None.
        cluster_name(str): The name of the cluster.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.cluster.create(
                ctx, cluster_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.cluster.create cluster_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="create_cluster",
        op_kwargs={"ClientToken": client_token, "ClusterName": cluster_name},
    )


async def delete(hub, ctx, cluster_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete a cluster.

    Args:
        cluster_arn(str): The Amazon Resource Name (ARN) of the cluster that you're deleting.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.cluster.delete(
                ctx, cluster_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.cluster.delete cluster_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="delete_cluster",
        op_kwargs={"ClusterArn": cluster_arn},
    )


async def describe(hub, ctx, cluster_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Display the details about a cluster. The response includes the cluster name, endpoints, status, and Amazon Resource Name (ARN).

    Args:
        cluster_arn(str): The Amazon Resource Name (ARN) of the cluster that you're getting details for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.cluster.describe(
                ctx, cluster_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.cluster.describe cluster_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="describe_cluster",
        op_kwargs={"ClusterArn": cluster_arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of all the clusters in an account.

    Args:
        max_results(int, optional): The number of objects that you want to return with this call. Defaults to None.
        next_token(str, optional): The token that identifies which batch of results you want to see. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.cluster.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.cluster.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="list_clusters",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
