"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, routing_control_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of all Amazon Route 53 health checks associated with a specific routing control.

    Args:
        max_results(int, optional): The number of objects that you want to return with this call. Defaults to None.
        next_token(str, optional): The token that identifies which batch of results you want to see. Defaults to None.
        routing_control_arn(str): The Amazon Resource Name (ARN) of the routing control that you're getting details for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_control_config.associated_route53_health_check.list_all(
                ctx, routing_control_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_control_config.associated_route53_health_check.list_all routing_control_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-control-config",
        operation="list_associated_route53_health_checks",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "RoutingControlArn": routing_control_arn,
        },
    )
