"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, routing_control_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Get the state for a routing control. A routing control is a simple on/off switch that you can use to route traffic to cells. When the state is On, traffic flows to a cell. When it's off, traffic does not flow.  Before you can create a routing control, you first must create a cluster to host the control. For more information, see CreateCluster. Access one of the endpoints for the cluster to get or update the routing control state to redirect traffic. For more information about working with routing controls, see Routing control in the Route 53 Application Recovery Controller Developer Guide.

    Args:
        routing_control_arn(str): The Amazon Resource Number (ARN) for the routing control that you want to get the state for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_cluster_routing_control_state.get(
                ctx, routing_control_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_cluster_routing_control_state.get routing_control_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-cluster",
        operation="get_routing_control_state",
        op_kwargs={"RoutingControlArn": routing_control_arn},
    )


async def update(
    hub, ctx, routing_control_arn: str, routing_control_state: str
) -> Dict:
    r"""
    **Autogenerated function**

    Set the state of the routing control to reroute traffic. You can set the value to be On or Off. When the state is On, traffic flows to a cell. When it's off, traffic does not flow. For more information about working with routing controls, see Routing control in the Route 53 Application Recovery Controller Developer Guide.

    Args:
        routing_control_arn(str): The Amazon Resource Number (ARN) for the routing control that you want to update the state for.
        routing_control_state(str): The state of the routing control. You can set the value to be On or Off.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_cluster_routing_control_state.update(
                ctx, routing_control_arn=value, routing_control_state=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_cluster_routing_control_state.update routing_control_arn=value, routing_control_state=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-cluster",
        operation="update_routing_control_state",
        op_kwargs={
            "RoutingControlArn": routing_control_arn,
            "RoutingControlState": routing_control_state,
        },
    )


async def update_multiple(hub, ctx, update_routing_control_state_entries: List) -> Dict:
    r"""
    **Autogenerated function**

    Set multiple routing control states. You can set the value for each state to be On or Off. When the state is On, traffic flows to a cell. When it's off, traffic does not flow. For more information about working with routing controls, see Routing control in the Route 53 Application Recovery Controller Developer Guide.

    Args:
        update_routing_control_state_entries(List): A set of routing control entries that you want to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_cluster_routing_control_state.update_multiple(
                ctx, update_routing_control_state_entries=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_cluster_routing_control_state.update_multiple update_routing_control_state_entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-cluster",
        operation="update_routing_control_states",
        op_kwargs={
            "UpdateRoutingControlStateEntries": update_routing_control_state_entries
        },
    )
