"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(
    hub, ctx, hosted_zone_id: str, vpc: Dict, comment: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates an Amazon Virtual Private Cloud (Amazon VPC) from an Amazon Route 53 private hosted zone. Note the following:   You can't disassociate the last Amazon VPC from a private hosted zone.   You can't convert a private hosted zone into a public hosted zone.   You can submit a DisassociateVPCFromHostedZone request using either the account that created the hosted zone or the account that created the Amazon VPC.   Some services, such as Cloud Map and Amazon Elastic File System (Amazon EFS) automatically create hosted zones and associate VPCs with the hosted zones. A service can create a hosted zone using your account or using its own account. You can disassociate a VPC from a hosted zone only if the service created the hosted zone using your account. When you run DisassociateVPCFromHostedZone, if the hosted zone has a value for OwningAccount, you can use DisassociateVPCFromHostedZone. If the hosted zone has a value for OwningService, you can't use DisassociateVPCFromHostedZone.

    Args:
        hosted_zone_id(str): The ID of the private hosted zone that you want to disassociate a VPC from.
        vpc(Dict): A complex type that contains information about the VPC that you're disassociating from the specified hosted zone.
        comment(str, optional):  Optional: A comment about the disassociation request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.vpc.from_hosted_zone.disassociate(
                ctx, hosted_zone_id=value, vpc=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.vpc.from_hosted_zone.disassociate hosted_zone_id=value, vpc=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="disassociate_vpc_from_hosted_zone",
        op_kwargs={"HostedZoneId": hosted_zone_id, "VPC": vpc, "Comment": comment},
    )
