"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, hosted_zone_id: str, vpc: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Authorizes the account that created a specified VPC to submit an AssociateVPCWithHostedZone request to associate the VPC with a specified hosted zone that was created by a different account. To submit a CreateVPCAssociationAuthorization request, you must use the account that created the hosted zone. After you authorize the association, use the account that created the VPC to submit an AssociateVPCWithHostedZone request.  If you want to associate multiple VPCs that you created by using one account with a hosted zone that you created by using a different account, you must submit one authorization request for each VPC.

    Args:
        hosted_zone_id(str): The ID of the private hosted zone that you want to authorize associating a VPC with.
        vpc(Dict): A complex type that contains the VPC ID and region for the VPC that you want to authorize associating with your hosted zone.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.vpc.association_authorization.create(
                ctx, hosted_zone_id=value, vpc=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.vpc.association_authorization.create hosted_zone_id=value, vpc=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="create_vpc_association_authorization",
        op_kwargs={"HostedZoneId": hosted_zone_id, "VPC": vpc},
    )


async def delete(hub, ctx, hosted_zone_id: str, vpc: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Removes authorization to submit an AssociateVPCWithHostedZone request to associate a specified VPC with a hosted zone that was created by a different account. You must use the account that created the hosted zone to submit a DeleteVPCAssociationAuthorization request.  Sending this request only prevents the account that created the VPC from associating the VPC with the Amazon Route 53 hosted zone in the future. If the VPC is already associated with the hosted zone, DeleteVPCAssociationAuthorization won't disassociate the VPC from the hosted zone. If you want to delete an existing association, use DisassociateVPCFromHostedZone.

    Args:
        hosted_zone_id(str): When removing authorization to associate a VPC that was created by one account with a hosted zone that was created with a different account, the ID of the hosted zone.
        vpc(Dict): When removing authorization to associate a VPC that was created by one account with a hosted zone that was created with a different account, a complex type that includes the ID and region of the VPC.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.vpc.association_authorization.delete(
                ctx, hosted_zone_id=value, vpc=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.vpc.association_authorization.delete hosted_zone_id=value, vpc=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="delete_vpc_association_authorization",
        op_kwargs={"HostedZoneId": hosted_zone_id, "VPC": vpc},
    )


async def list_all(
    hub, ctx, hosted_zone_id: str, next_token: str = None, max_results: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the VPCs that were created by other accounts and that can be associated with a specified hosted zone because you've submitted one or more CreateVPCAssociationAuthorization requests.  The response includes a VPCs element with a VPC child element for each VPC that can be associated with the hosted zone.

    Args:
        hosted_zone_id(str): The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.
        next_token(str, optional):  Optional: If a response includes a NextToken element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of results, submit another request, and include the value of NextToken from the response in the nexttoken parameter in another ListVPCAssociationAuthorizations request. Defaults to None.
        max_results(str, optional):  Optional: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return. If you don't specify a value for MaxResults, Route 53 returns up to 50 VPCs per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.vpc.association_authorization.list_all(
                ctx, hosted_zone_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.vpc.association_authorization.list_all hosted_zone_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="list_vpc_association_authorizations",
        op_kwargs={
            "HostedZoneId": hosted_zone_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
