"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, id_: str, document: str, comment: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new version of an existing traffic policy. When you create a new version of a traffic policy, you specify the ID of the traffic policy that you want to update and a JSON-formatted document that describes the new version. You use traffic policies to create multiple DNS resource record sets for one domain name (such as example.com) or one subdomain name (such as www.example.com). You can create a maximum of 1000 versions of a traffic policy. If you reach the limit and need to create another version, you'll need to start a new traffic policy.

    Args:
        id_(str): The ID of the traffic policy for which you want to create a new version.
        document(str): The definition of this version of the traffic policy, in JSON format. You specified the JSON in the CreateTrafficPolicyVersion request. For more information about the JSON format, see CreateTrafficPolicy.
        comment(str, optional): The comment that you specified in the CreateTrafficPolicyVersion request, if any. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.version.create(
                ctx, id_=value, document=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.version.create id_=value, document=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="create_traffic_policy_version",
        op_kwargs={"Id": id_, "Document": document, "Comment": comment},
    )


async def list_all(
    hub, ctx, id_: str, traffic_policy_version_marker: str = None, max_items: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about all of the versions for a specified traffic policy. Traffic policy versions are listed in numerical order by VersionNumber.

    Args:
        id_(str): Specify the value of Id of the traffic policy for which you want to list all versions.
        traffic_policy_version_marker(str, optional): For your first request to ListTrafficPolicyVersions, don't include the TrafficPolicyVersionMarker parameter. If you have more traffic policy versions than the value of MaxItems, ListTrafficPolicyVersions returns only the first group of MaxItems versions. To get more traffic policy versions, submit another ListTrafficPolicyVersions request. For the value of TrafficPolicyVersionMarker, specify the value of TrafficPolicyVersionMarker in the previous response. Defaults to None.
        max_items(str, optional): The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for this request. If the specified traffic policy has more than MaxItems versions, the value of IsTruncated in the response is true, and the value of the TrafficPolicyVersionMarker element is the ID of the first version that Route 53 will return if you submit another request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.version.list_all(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.version.list_all id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="list_traffic_policy_versions",
        op_kwargs={
            "Id": id_,
            "TrafficPolicyVersionMarker": traffic_policy_version_marker,
            "MaxItems": max_items,
        },
    )
