"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    hosted_zone_id: str,
    name: str,
    ttl: int,
    traffic_policy_id: str,
    traffic_policy_version: int,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates resource record sets in a specified hosted zone based on the settings in a specified traffic policy version. In addition, CreateTrafficPolicyInstance associates the resource record sets with a specified domain name (such as example.com) or subdomain name (such as www.example.com). Amazon Route 53 responds to DNS queries for the domain or subdomain name by using the resource record sets that CreateTrafficPolicyInstance created.

    Args:
        hosted_zone_id(str): The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
        name(str): The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
        ttl(int): (Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.
        traffic_policy_id(str): The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
        traffic_policy_version(int): The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.instance.init.create(
                ctx,
                hosted_zone_id=value,
                name=value,
                ttl=value,
                traffic_policy_id=value,
                traffic_policy_version=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.instance.init.create hosted_zone_id=value, name=value, ttl=value, traffic_policy_id=value, traffic_policy_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="create_traffic_policy_instance",
        op_kwargs={
            "HostedZoneId": hosted_zone_id,
            "Name": name,
            "TTL": ttl,
            "TrafficPolicyId": traffic_policy_id,
            "TrafficPolicyVersion": traffic_policy_version,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a traffic policy instance and all of the resource record sets that Amazon Route 53 created when you created the instance.  In the Route 53 console, traffic policy instances are known as policy records.

    Args:
        id_(str): The ID of the traffic policy instance that you want to delete.   When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were created when you created the traffic policy instance. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.instance.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.instance.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="delete_traffic_policy_instance",
        op_kwargs={"Id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a specified traffic policy instance.  After you submit a CreateTrafficPolicyInstance or an UpdateTrafficPolicyInstance request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the State response element.   In the Route 53 console, traffic policy instances are known as policy records.

    Args:
        id_(str): The ID of the traffic policy instance that you want to get information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.instance.init.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.instance.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="get_traffic_policy_instance",
        op_kwargs={"Id": id_},
    )


async def list_all(
    hub,
    ctx,
    hosted_zone_id_marker: str = None,
    traffic_policy_instance_name_marker: str = None,
    traffic_policy_instance_type_marker: str = None,
    max_items: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the traffic policy instances that you created by using the current account.  After you submit an UpdateTrafficPolicyInstance request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the State response element.  Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can use the MaxItems parameter to list them in groups of up to 100.

    Args:
        hosted_zone_id_marker(str, optional): If the value of IsTruncated in the previous response was true, you have more traffic policy instances. To get more traffic policy instances, submit another ListTrafficPolicyInstances request. For the value of HostedZoneId, specify the value of HostedZoneIdMarker from the previous response, which is the hosted zone ID of the first traffic policy instance in the next group of traffic policy instances. If the value of IsTruncated in the previous response was false, there are no more traffic policy instances to get. Defaults to None.
        traffic_policy_instance_name_marker(str, optional): If the value of IsTruncated in the previous response was true, you have more traffic policy instances. To get more traffic policy instances, submit another ListTrafficPolicyInstances request. For the value of trafficpolicyinstancename, specify the value of TrafficPolicyInstanceNameMarker from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances. If the value of IsTruncated in the previous response was false, there are no more traffic policy instances to get. Defaults to None.
        traffic_policy_instance_type_marker(str, optional): If the value of IsTruncated in the previous response was true, you have more traffic policy instances. To get more traffic policy instances, submit another ListTrafficPolicyInstances request. For the value of trafficpolicyinstancetype, specify the value of TrafficPolicyInstanceTypeMarker from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances. If the value of IsTruncated in the previous response was false, there are no more traffic policy instances to get. Defaults to None.
        max_items(str, optional): The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a ListTrafficPolicyInstances request. If you have more than MaxItems traffic policy instances, the value of the IsTruncated element in the response is true, and the values of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker represent the first traffic policy instance in the next group of MaxItems traffic policy instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.instance.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.instance.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="list_traffic_policy_instances",
        op_kwargs={
            "HostedZoneIdMarker": hosted_zone_id_marker,
            "TrafficPolicyInstanceNameMarker": traffic_policy_instance_name_marker,
            "TrafficPolicyInstanceTypeMarker": traffic_policy_instance_type_marker,
            "MaxItems": max_items,
        },
    )


async def update(
    hub, ctx, id_: str, ttl: int, traffic_policy_id: str, traffic_policy_version: int
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the resource record sets in a specified hosted zone that were created based on the settings in a specified traffic policy version. When you update a traffic policy instance, Amazon Route 53 continues to respond to DNS queries for the root resource record set name (such as example.com) while it replaces one group of resource record sets with another. Route 53 performs the following operations:   Route 53 creates a new group of resource record sets based on the specified traffic policy. This is true regardless of how significant the differences are between the existing resource record sets and the new resource record sets.    When all of the new resource record sets have been created, Route 53 starts to respond to DNS queries for the root resource record set name (such as example.com) by using the new resource record sets.   Route 53 deletes the old group of resource record sets that are associated with the root resource record set name.

    Args:
        id_(str): The ID of the traffic policy instance that you want to update.
        ttl(int): The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.
        traffic_policy_id(str): The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.
        traffic_policy_version(int): The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.instance.init.update(
                ctx, id_=value, ttl=value, traffic_policy_id=value, traffic_policy_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.instance.init.update id_=value, ttl=value, traffic_policy_id=value, traffic_policy_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="update_traffic_policy_instance",
        op_kwargs={
            "Id": id_,
            "TTL": ttl,
            "TrafficPolicyId": traffic_policy_id,
            "TrafficPolicyVersion": traffic_policy_version,
        },
    )
