"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Gets the number of traffic policy instances that are associated with the current account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.instance.count.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.instance.count.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="get_traffic_policy_instance_count",
        op_kwargs={},
    )
