"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    hosted_zone_id: str,
    traffic_policy_instance_name_marker: str = None,
    traffic_policy_instance_type_marker: str = None,
    max_items: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the traffic policy instances that you created in a specified hosted zone.  After you submit a CreateTrafficPolicyInstance or an UpdateTrafficPolicyInstance request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the State response element.  Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can use the MaxItems parameter to list them in groups of up to 100.

    Args:
        hosted_zone_id(str): The ID of the hosted zone that you want to list traffic policy instances for.
        traffic_policy_instance_name_marker(str, optional): If the value of IsTruncated in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another ListTrafficPolicyInstances request. For the value of trafficpolicyinstancename, specify the value of TrafficPolicyInstanceNameMarker from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances. If the value of IsTruncated in the previous response was false, there are no more traffic policy instances to get. Defaults to None.
        traffic_policy_instance_type_marker(str, optional): If the value of IsTruncated in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another ListTrafficPolicyInstances request. For the value of trafficpolicyinstancetype, specify the value of TrafficPolicyInstanceTypeMarker from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances. If the value of IsTruncated in the previous response was false, there are no more traffic policy instances to get. Defaults to None.
        max_items(str, optional): The maximum number of traffic policy instances to be included in the response body for this request. If you have more than MaxItems traffic policy instances, the value of the IsTruncated element in the response is true, and the values of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker represent the first traffic policy instance that Amazon Route 53 will return if you submit another request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.instance.by.hosted_zone.list(
                ctx, hosted_zone_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.instance.by.hosted_zone.list hosted_zone_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="list_traffic_policy_instances_by_hosted_zone",
        op_kwargs={
            "HostedZoneId": hosted_zone_id,
            "TrafficPolicyInstanceNameMarker": traffic_policy_instance_name_marker,
            "TrafficPolicyInstanceTypeMarker": traffic_policy_instance_type_marker,
            "MaxItems": max_items,
        },
    )
