"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, document: str, comment: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a traffic policy, which you use to create multiple DNS resource record sets for one domain name (such as example.com) or one subdomain name (such as www.example.com).

    Args:
        name(str): The name of the traffic policy.
        document(str): The definition of this traffic policy in JSON format. For more information, see Traffic Policy Document Format.
        comment(str, optional): (Optional) Any comments that you want to include about the traffic policy. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.init.create(
                ctx, name=value, document=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.init.create name=value, document=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="create_traffic_policy",
        op_kwargs={"Name": name, "Document": document, "Comment": comment},
    )


async def delete(hub, ctx, id_: str, version: int) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a traffic policy. When you delete a traffic policy, Route 53 sets a flag on the policy to indicate that it has been deleted. However, Route 53 never fully deletes the traffic policy. Note the following:   Deleted traffic policies aren't listed if you run ListTrafficPolicies.    There's no way to get a list of deleted policies.   If you retain the ID of the policy, you can get information about the policy, including the traffic policy document, by running GetTrafficPolicy.

    Args:
        id_(str): The ID of the traffic policy that you want to delete.
        version(int): The version number of the traffic policy that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.init.delete(
                ctx, id_=value, version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.init.delete id_=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="delete_traffic_policy",
        op_kwargs={"Id": id_, "Version": version},
    )


async def get(hub, ctx, id_: str, version: int) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a specific traffic policy version. For information about how of deleting a traffic policy affects the response from GetTrafficPolicy, see DeleteTrafficPolicy.

    Args:
        id_(str): The ID of the traffic policy that you want to get information about.
        version(int): The version number of the traffic policy that you want to get information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.init.get(ctx, id_=value, version=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.init.get id_=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="get_traffic_policy",
        op_kwargs={"Id": id_, "Version": version},
    )


async def list_all(
    hub, ctx, traffic_policy_id_marker: str = None, max_items: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the latest version for every traffic policy that is associated with the current account. Policies are listed in the order that they were created in.  For information about how of deleting a traffic policy affects the response from ListTrafficPolicies, see DeleteTrafficPolicy.

    Args:
        traffic_policy_id_marker(str, optional): (Conditional) For your first request to ListTrafficPolicies, don't include the TrafficPolicyIdMarker parameter. If you have more traffic policies than the value of MaxItems, ListTrafficPolicies returns only the first MaxItems traffic policies. To get the next group of policies, submit another request to ListTrafficPolicies. For the value of TrafficPolicyIdMarker, specify the value of TrafficPolicyIdMarker that was returned in the previous response. Defaults to None.
        max_items(str, optional): (Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this request. If you have more than MaxItems traffic policies, the value of IsTruncated in the response is true, and the value of TrafficPolicyIdMarker is the ID of the first traffic policy that Route 53 will return if you submit another request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="list_traffic_policies",
        op_kwargs={
            "TrafficPolicyIdMarker": traffic_policy_id_marker,
            "MaxItems": max_items,
        },
    )
