"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, id_: str, version: int, comment: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the comment for a specified traffic policy version.

    Args:
        id_(str): The value of Id for the traffic policy that you want to update the comment for.
        version(int): The value of Version for the traffic policy that you want to update the comment for.
        comment(str): The new comment for the specified traffic policy and version.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.traffic_policy.comment.update(
                ctx, id_=value, version=value, comment=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.traffic_policy.comment.update id_=value, version=value, comment=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="update_traffic_policy_comment",
        op_kwargs={"Id": id_, "Version": version, "Comment": comment},
    )
