"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def change(
    hub,
    ctx,
    resource_type: str,
    resource_id: str,
    add_tags: List = None,
    remove_tag_keys: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds, edits, or deletes tags for a health check or a hosted zone. For information about using tags for cost allocation, see Using Cost Allocation Tags in the Billing and Cost Management User Guide.

    Args:
        resource_type(str): The type of the resource.   The resource type for health checks is healthcheck.   The resource type for hosted zones is hostedzone.  .
        resource_id(str): The ID of the resource for which you want to add, change, or delete tags.
        add_tags(List, optional): A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags that you want to edit Value for. You can add a maximum of 10 tags to a health check or a hosted zone. Defaults to None.
        remove_tag_keys(List, optional): A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone. You can specify up to 10 keys. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.tags_for_resource.change(
                ctx, resource_type=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.tags_for_resource.change resource_type=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="change_tags_for_resource",
        op_kwargs={
            "ResourceType": resource_type,
            "ResourceId": resource_id,
            "AddTags": add_tags,
            "RemoveTagKeys": remove_tag_keys,
        },
    )


async def list_(hub, ctx, resource_type: str, resource_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists tags for one health check or hosted zone.  For information about using tags for cost allocation, see Using Cost Allocation Tags in the Billing and Cost Management User Guide.

    Args:
        resource_type(str): The type of the resource.   The resource type for health checks is healthcheck.   The resource type for hosted zones is hostedzone.  .
        resource_id(str): The ID of the resource for which you want to retrieve tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.tags_for_resource.list(
                ctx, resource_type=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.tags_for_resource.list resource_type=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="list_tags_for_resource",
        op_kwargs={"ResourceType": resource_type, "ResourceId": resource_id},
    )


async def list_all(hub, ctx, resource_type: str, resource_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Lists tags for up to 10 health checks or hosted zones. For information about using tags for cost allocation, see Using Cost Allocation Tags in the Billing and Cost Management User Guide.

    Args:
        resource_type(str): The type of the resources.   The resource type for health checks is healthcheck.   The resource type for hosted zones is hostedzone.  .
        resource_ids(List): A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.tags_for_resource.list_all(
                ctx, resource_type=value, resource_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.tags_for_resource.list_all resource_type=value, resource_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="list_tags_for_resources",
        op_kwargs={"ResourceType": resource_type, "ResourceIds": resource_ids},
    )
