"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, type_: str, delegation_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the maximum number of hosted zones that you can associate with the specified reusable delegation set. For the default limit, see Limits in the Amazon Route 53 Developer Guide. To request a higher limit, open a case.

    Args:
        type_(str): Specify MAX_ZONES_BY_REUSABLE_DELEGATION_SET to get the maximum number of hosted zones that you can associate with the specified reusable delegation set.
        delegation_set_id(str): The ID of the delegation set that you want to get the limit for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.reusable_delegation_set_.limit.get(
                ctx, type_=value, delegation_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.reusable_delegation_set_.limit.get type_=value, delegation_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="get_reusable_delegation_set_limit",
        op_kwargs={"Type": type_, "DelegationSetId": delegation_set_id},
    )
