"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, caller_reference: str, hosted_zone_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a delegation set (a group of four name servers) that can be reused by multiple hosted zones that were created by the same account.  You can also create a reusable delegation set that uses the four name servers that are associated with an existing hosted zone. Specify the hosted zone ID in the CreateReusableDelegationSet request.  You can't associate a reusable delegation set with a private hosted zone.  For information about using a reusable delegation set to configure white label name servers, see Configuring White Label Name Servers. The process for migrating existing hosted zones to use a reusable delegation set is comparable to the process for configuring white label name servers. You need to perform the following steps:   Create a reusable delegation set.   Recreate hosted zones, and reduce the TTL to 60 seconds or less.   Recreate resource record sets in the new hosted zones.   Change the registrar's name servers to use the name servers for the new hosted zones.   Monitor traffic for the website or application.   Change TTLs back to their original values.   If you want to migrate existing hosted zones to use a reusable delegation set, the existing hosted zones can't use any of the name servers that are assigned to the reusable delegation set. If one or more hosted zones do use one or more name servers that are assigned to the reusable delegation set, you can do one of the following:   For small numbers of hosted zones—up to a few hundred—it's relatively easy to create reusable delegation sets until you get one that has four name servers that don't overlap with any of the name servers in your hosted zones.   For larger numbers of hosted zones, the easiest solution is to use more than one reusable delegation set.   For larger numbers of hosted zones, you can also migrate hosted zones that have overlapping name servers to hosted zones that don't have overlapping name servers, then migrate the hosted zones again to use the reusable delegation set.

    Args:
        caller_reference(str): A unique string that identifies the request, and that allows you to retry failed CreateReusableDelegationSet requests without the risk of executing the operation twice. You must use a unique CallerReference string every time you submit a CreateReusableDelegationSet request. CallerReference can be any unique string, for example a date/time stamp.
        hosted_zone_id(str, optional): If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.reusable_delegation_set_.init.create(
                ctx, caller_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.reusable_delegation_set_.init.create caller_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="create_reusable_delegation_set",
        op_kwargs={"CallerReference": caller_reference, "HostedZoneId": hosted_zone_id},
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a reusable delegation set.  You can delete a reusable delegation set only if it isn't associated with any hosted zones.  To verify that the reusable delegation set is not associated with any hosted zones, submit a GetReusableDelegationSet request and specify the ID of the reusable delegation set that you want to delete.

    Args:
        id_(str): The ID of the reusable delegation set that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.reusable_delegation_set_.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.reusable_delegation_set_.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="delete_reusable_delegation_set",
        op_kwargs={"Id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a specified reusable delegation set, including the four name servers that are assigned to the delegation set.

    Args:
        id_(str): The ID of the reusable delegation set that you want to get a list of name servers for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.reusable_delegation_set_.init.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.reusable_delegation_set_.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="get_reusable_delegation_set",
        op_kwargs={"Id": id_},
    )


async def list_all(hub, ctx, marker: str = None, max_items: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of the reusable delegation sets that are associated with the current account.

    Args:
        marker(str, optional): If the value of IsTruncated in the previous response was true, you have more reusable delegation sets. To get another group, submit another ListReusableDelegationSets request.  For the value of marker, specify the value of NextMarker from the previous response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request. If the value of IsTruncated in the previous response was false, there are no more reusable delegation sets to get. Defaults to None.
        max_items(str, optional): The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value greater than 100, Route 53 returns only the first 100 reusable delegation sets. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.reusable_delegation_set_.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.reusable_delegation_set_.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="list_reusable_delegation_sets",
        op_kwargs={"Marker": marker, "MaxItems": max_items},
    )
