"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, type_: str, hosted_zone_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the specified limit for a specified hosted zone, for example, the maximum number of records that you can create in the hosted zone.  For the default limit, see Limits in the Amazon Route 53 Developer Guide. To request a higher limit, open a case.

    Args:
        type_(str): The limit that you want to get. Valid values include the following:    MAX_RRSETS_BY_ZONE: The maximum number of records that you can create in the specified hosted zone.    MAX_VPCS_ASSOCIATED_BY_ZONE: The maximum number of Amazon VPCs that you can associate with the specified private hosted zone.  .
        hosted_zone_id(str): The ID of the hosted zone that you want to get a limit for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.hosted_zone.limit.get(
                ctx, type_=value, hosted_zone_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.hosted_zone.limit.get type_=value, hosted_zone_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="get_hosted_zone_limit",
        op_kwargs={"Type": type_, "HostedZoneId": hosted_zone_id},
    )
