"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, hosted_zone_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables DNSSEC signing in a specific hosted zone. This action does not deactivate any key-signing keys (KSKs) that are active in the hosted zone.

    Args:
        hosted_zone_id(str): A unique string used to identify a hosted zone.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.hosted_zone.dnssec.disable(ctx, hosted_zone_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.hosted_zone.dnssec.disable hosted_zone_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="disable_hosted_zone_dnssec",
        op_kwargs={"HostedZoneId": hosted_zone_id},
    )


async def enable(hub, ctx, hosted_zone_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Enables DNSSEC signing in a specific hosted zone.

    Args:
        hosted_zone_id(str): A unique string used to identify a hosted zone.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.hosted_zone.dnssec.enable(ctx, hosted_zone_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.hosted_zone.dnssec.enable hosted_zone_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="enable_hosted_zone_dnssec",
        op_kwargs={"HostedZoneId": hosted_zone_id},
    )
