"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the number of hosted zones that are associated with the current account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.hosted_zone.count.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.hosted_zone.count.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="route53", operation="get_hosted_zone_count", op_kwargs={}
    )
