"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, id_: str, comment: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the comment for a specified hosted zone.

    Args:
        id_(str): The ID for the hosted zone that you want to update the comment for.
        comment(str, optional): The new comment for the hosted zone. If you don't specify a value for Comment, Amazon Route 53 deletes the existing value of the Comment element, if any. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.hosted_zone.comment.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.hosted_zone.comment.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="update_hosted_zone_comment",
        op_kwargs={"Id": id_, "Comment": comment},
    )
