"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    vpc_id: str,
    vpc_region: str,
    max_items: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the private hosted zones that a specified VPC is associated with, regardless of which account or Amazon Web Services service owns the hosted zones. The HostedZoneOwner structure in the response contains one of the following values:   An OwningAccount element, which contains the account number of either the current account or another account. Some services, such as Cloud Map, create hosted zones using the current account.    An OwningService element, which identifies the Amazon Web Services service that created and owns the hosted zone. For example, if a hosted zone was created by Amazon Elastic File System (Amazon EFS), the value of Owner is efs.amazonaws.com.

    Args:
        vpc_id(str): The ID of the Amazon VPC that you want to list hosted zones for.
        vpc_region(str): For the Amazon VPC that you specified for VPCId, the Amazon Web Services Region that you created the VPC in. .
        max_items(str, optional): (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with more than MaxItems hosted zones, the response includes a NextToken element. NextToken contains an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request. Defaults to None.
        next_token(str, optional): If the previous response included a NextToken element, the specified VPC is associated with more hosted zones. To get more hosted zones, submit another ListHostedZonesByVPC request.  For the value of NextToken, specify the value of NextToken from the previous response. If the previous response didn't include a NextToken element, there are no more hosted zones to get. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.hosted_zone.by.vpc.list(
                ctx, vpc_id=value, vpc_region=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.hosted_zone.by.vpc.list vpc_id=value, vpc_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="list_hosted_zones_by_vpc",
        op_kwargs={
            "VPCId": vpc_id,
            "VPCRegion": vpc_region,
            "MaxItems": max_items,
            "NextToken": next_token,
        },
    )
