"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, health_check_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets status of a specified health check.   This API is intended for use during development to diagnose behavior. It doesn’t support production use-cases with high query rates that require immediate and actionable responses.

    Args:
        health_check_id(str): The ID for the health check that you want the current status for. When you created the health check, CreateHealthCheck returned the ID in the response, in the HealthCheckId element.  If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use GetHealthCheckStatus to get the status of a calculated health check. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.health_check.status.get(ctx, health_check_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.health_check.status.get health_check_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="get_health_check_status",
        op_kwargs={"HealthCheckId": health_check_id},
    )
