"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, health_check_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the reason that a specified health check failed most recently.

    Args:
        health_check_id(str): The ID for the health check for which you want the last failure reason. When you created the health check, CreateHealthCheck returned the ID in the response, in the HealthCheckId element.  If you want to get the last failure reason for a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use GetHealthCheckLastFailureReason for a calculated health check. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.health_check.last_failure_reason.get(
                ctx, health_check_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.health_check.last_failure_reason.get health_check_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="get_health_check_last_failure_reason",
        op_kwargs={"HealthCheckId": health_check_id},
    )
