"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    continent_code: str = None,
    country_code: str = None,
    subdivision_code: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation resource record sets. Route 53 does not perform authorization for this API because it retrieves information that is already available to the public. Use the following syntax to determine whether a continent is supported for geolocation:  GET /2013-04-01/geolocation?continentcode=two-letter abbreviation for a continent   Use the following syntax to determine whether a country is supported for geolocation:  GET /2013-04-01/geolocation?countrycode=two-character country code   Use the following syntax to determine whether a subdivision of a country is supported for geolocation:  GET /2013-04-01/geolocation?countrycode=two-character country code&subdivisioncode=subdivision code

    Args:
        continent_code(str, optional): For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:    AF: Africa    AN: Antarctica    AS: Asia    EU: Europe    OC: Oceania    NA: North America    SA: South America  . Defaults to None.
        country_code(str, optional): Amazon Route 53 uses the two-letter country codes that are specified in ISO standard 3166-1 alpha-2. Defaults to None.
        subdivision_code(str, optional): The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see Appendix B: Two–Letter State and Possession Abbreviations on the United States Postal Service website. For a list of all supported subdivision codes, use the ListGeoLocations API. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.geo_location.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.geo_location.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="get_geo_location",
        op_kwargs={
            "ContinentCode": continent_code,
            "CountryCode": country_code,
            "SubdivisionCode": subdivision_code,
        },
    )


async def list_all(
    hub,
    ctx,
    start_continent_code: str = None,
    start_country_code: str = None,
    start_subdivision_code: str = None,
    max_items: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of supported geographic locations. Countries are listed first, and continents are listed last. If Amazon Route 53 supports subdivisions for a country (for example, states or provinces), the subdivisions for that country are listed in alphabetical order immediately after the corresponding country. Route 53 does not perform authorization for this API because it retrieves information that is already available to the public. For a list of supported geolocation codes, see the GeoLocation data type.

    Args:
        start_continent_code(str, optional): The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if IsTruncated is true, and if NextContinentCode from the previous response has a value, enter that value in startcontinentcode to return the next page of results. Include startcontinentcode only if you want to list continents. Don't include startcontinentcode when you're listing countries or countries with their subdivisions. Defaults to None.
        start_country_code(str, optional): The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if IsTruncated is true, and if NextCountryCode from the previous response has a value, enter that value in startcountrycode to return the next page of results. Defaults to None.
        start_subdivision_code(str, optional): The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if IsTruncated is true, and if NextSubdivisionCode from the previous response has a value, enter that value in startsubdivisioncode to return the next page of results. To list subdivisions (U.S. states), you must include both startcountrycode and startsubdivisioncode. Defaults to None.
        max_items(str, optional): (Optional) The maximum number of geolocations to be included in the response body for this request. If more than maxitems geolocations remain to be listed, then the value of the IsTruncated element in the response is true. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.geo_location.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.geo_location.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="list_geo_locations",
        op_kwargs={
            "StartContinentCode": start_continent_code,
            "StartCountryCode": start_country_code,
            "StartSubdivisionCode": start_subdivision_code,
            "MaxItems": max_items,
        },
    )
