"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, hosted_zone_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about DNSSEC for a specific hosted zone, including the key-signing keys (KSKs) in the hosted zone.

    Args:
        hosted_zone_id(str): A unique string used to identify a hosted zone.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.dnssec.get(ctx, hosted_zone_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.dnssec.get hosted_zone_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="get_dnssec",
        op_kwargs={"HostedZoneId": hosted_zone_id},
    )
