"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def test(
    hub,
    ctx,
    hosted_zone_id: str,
    record_name: str,
    record_type: str,
    resolver_ip: str = None,
    edns0_client_subnet_ip: str = None,
    edns0_client_subnet_mask: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask.  This call only supports querying public hosted zones.

    Args:
        hosted_zone_id(str): The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
        record_name(str): The name of the resource record set that you want Amazon Route 53 to simulate a query for.
        record_type(str): The type of the resource record set.
        resolver_ip(str, optional): If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you omit this value, TestDnsAnswer uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region (us-east-1). Defaults to None.
        edns0_client_subnet_ip(str, optional): If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in the applicable location, for example, 192.0.2.44 or 2001:db8:85a3::8a2e:370:7334. Defaults to None.
        edns0_client_subnet_mask(str, optional): If you specify an IP address for edns0clientsubnetip, you can optionally specify the number of bits of the IP address that you want the checking tool to include in the DNS query. For example, if you specify 192.0.2.44 for edns0clientsubnetip and 24 for edns0clientsubnetmask, the checking tool will simulate a request from 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses. The range of valid values depends on whether edns0clientsubnetip is an IPv4 or an IPv6 address:    IPv4: Specify a value between 0 and 32    IPv6: Specify a value between 0 and 128  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.dns.answer.test(
                ctx, hosted_zone_id=value, record_name=value, record_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.dns.answer.test hosted_zone_id=value, record_name=value, record_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53",
        operation="test_dns_answer",
        op_kwargs={
            "HostedZoneId": hosted_zone_id,
            "RecordName": record_name,
            "RecordType": record_type,
            "ResolverIP": resolver_ip,
            "EDNS0ClientSubnetIP": edns0_client_subnet_ip,
            "EDNS0ClientSubnetMask": edns0_client_subnet_mask,
        },
    )
