"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "checker_ip_range"


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Route 53 does not perform authorization for this API because it retrieves information that is already available to the public.   GetCheckerIpRanges still works, but we recommend that you download ip-ranges.json, which includes IP address ranges for all Amazon Web Services services. For more information, see IP Address Ranges of Amazon Route 53 Servers in the Amazon Route 53 Developer Guide.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53.checker_ip_range_.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53.checker_ip_range.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="route53", operation="get_checker_ip_ranges", op_kwargs={}
    )
