"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    client_request_token: str = None,
    name: str = None,
    template_body: str = None,
    template_location: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a world template.

    Args:
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        name(str, optional): The name of the world template. Defaults to None.
        template_body(str, optional): The world template body. Defaults to None.
        template_location(Dict, optional): The location of the world template. Defaults to None.
        tags(Dict, optional): A map that contains tag keys and tag values that are attached to the world template. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.template.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.template.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="create_world_template",
        op_kwargs={
            "clientRequestToken": client_request_token,
            "name": name,
            "templateBody": template_body,
            "templateLocation": template_location,
            "tags": tags,
        },
    )


async def delete(hub, ctx, template: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a world template.

    Args:
        template(str): The Amazon Resource Name (arn) of the world template you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.template.init.delete(ctx, template=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.template.init.delete template=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="delete_world_template",
        op_kwargs={"template": template},
    )


async def describe(hub, ctx, template: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a world template.

    Args:
        template(str): The Amazon Resource Name (arn) of the world template you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.template.init.describe(ctx, template=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.template.init.describe template=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="describe_world_template",
        op_kwargs={"template": template},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists world templates.

    Args:
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object's nextToken parameter value is set to a token. To retrieve the next set of results, call ListWorldTemplates again and assign that token to the request object's nextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. . Defaults to None.
        max_results(int, optional): When this parameter is used, ListWorldTemplates only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListWorldTemplates request with the returned nextToken value. This value can be between 1 and 100. If this parameter is not used, then ListWorldTemplates returns up to 100 results and a nextToken value if applicable. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.template.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.template.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="list_world_templates",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    template: str,
    name: str = None,
    template_body: str = None,
    template_location: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a world template.

    Args:
        template(str): The Amazon Resource Name (arn) of the world template to update.
        name(str, optional): The name of the template. Defaults to None.
        template_body(str, optional): The world template body. Defaults to None.
        template_location(Dict, optional): The location of the world template. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.template.init.update(ctx, template=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.template.init.update template=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="update_world_template",
        op_kwargs={
            "template": template,
            "name": name,
            "templateBody": template_body,
            "templateLocation": template_location,
        },
    )
