"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, template: str = None, generation_job: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the world template body.

    Args:
        template(str, optional): The Amazon Resource Name (arn) of the world template. Defaults to None.
        generation_job(str, optional): The Amazon Resource Name (arn) of the world generator job. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.template.body.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.template.body.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="get_world_template_body",
        op_kwargs={"template": template, "generationJob": generation_job},
    )
