"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, world: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a world.

    Args:
        world(str): The Amazon Resource Name (arn) of the world you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.init.describe(ctx, world=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.init.describe world=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="describe_world",
        op_kwargs={"world": world},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists worlds.

    Args:
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object's nextToken parameter value is set to a token. To retrieve the next set of results, call ListWorlds again and assign that token to the request object's nextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. . Defaults to None.
        max_results(int, optional): When this parameter is used, ListWorlds only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListWorlds request with the returned nextToken value. This value can be between 1 and 100. If this parameter is not used, then ListWorlds returns up to 100 results and a nextToken value if applicable. . Defaults to None.
        filters(List, optional): Optional filters to limit results. You can use status. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="list_worlds",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "filters": filters,
        },
    )
