"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, job: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the specified world generator job.

    Args:
        job(str): The Amazon Resource Name (arn) of the world generator job to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.generation_job.cancel(ctx, job=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.generation_job.cancel job=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="cancel_world_generation_job",
        op_kwargs={"job": job},
    )


async def create(
    hub,
    ctx,
    template: str,
    world_count: Dict,
    client_request_token: str = None,
    tags: Dict = None,
    world_tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates worlds using the specified template.

    Args:
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        template(str): The Amazon Resource Name (arn) of the world template describing the worlds you want to create.
        world_count(Dict): Information about the world count.
        tags(Dict, optional): A map that contains tag keys and tag values that are attached to the world generator job. Defaults to None.
        world_tags(Dict, optional): A map that contains tag keys and tag values that are attached to the generated worlds. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.generation_job.create(
                ctx, template=value, world_count=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.generation_job.create template=value, world_count=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="create_world_generation_job",
        op_kwargs={
            "clientRequestToken": client_request_token,
            "template": template,
            "worldCount": world_count,
            "tags": tags,
            "worldTags": world_tags,
        },
    )


async def describe(hub, ctx, job: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a world generation job.

    Args:
        job(str): The Amazon Resource Name (arn) of the world generation job to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.generation_job.describe(ctx, job=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.generation_job.describe job=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="describe_world_generation_job",
        op_kwargs={"job": job},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists world generator jobs.

    Args:
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object's nextToken parameter value is set to a token. To retrieve the next set of results, call ListWorldGenerationJobsRequest again and assign that token to the request object's nextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. . Defaults to None.
        max_results(int, optional): When this parameter is used, ListWorldGeneratorJobs only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListWorldGeneratorJobs request with the returned nextToken value. This value can be between 1 and 100. If this parameter is not used, then ListWorldGeneratorJobs returns up to 100 results and a nextToken value if applicable. . Defaults to None.
        filters(List, optional): Optional filters to limit results. You can use status and templateId. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.generation_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.generation_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="list_world_generation_jobs",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "filters": filters,
        },
    )
