"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, job: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the specified export job.

    Args:
        job(str): The Amazon Resource Name (arn) of the world export job to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.export_job.cancel(ctx, job=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.export_job.cancel job=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="cancel_world_export_job",
        op_kwargs={"job": job},
    )


async def create(
    hub,
    ctx,
    worlds: List,
    output_location: Dict,
    iam_role: str,
    client_request_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a world export job.

    Args:
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        worlds(List): A list of Amazon Resource Names (arns) that correspond to worlds to export.
        output_location(Dict): The output location.
        iam_role(str): The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
        tags(Dict, optional): A map that contains tag keys and tag values that are attached to the world export job. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.export_job.create(
                ctx, worlds=value, output_location=value, iam_role=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.export_job.create worlds=value, output_location=value, iam_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="create_world_export_job",
        op_kwargs={
            "clientRequestToken": client_request_token,
            "worlds": worlds,
            "outputLocation": output_location,
            "iamRole": iam_role,
            "tags": tags,
        },
    )


async def describe(hub, ctx, job: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a world export job.

    Args:
        job(str): The Amazon Resource Name (arn) of the world export job to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.export_job.describe(ctx, job=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.export_job.describe job=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="describe_world_export_job",
        op_kwargs={"job": job},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists world export jobs.

    Args:
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object's nextToken parameter value is set to a token. To retrieve the next set of results, call ListWorldExportJobs again and assign that token to the request object's nextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. . Defaults to None.
        max_results(int, optional): When this parameter is used, ListWorldExportJobs only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListWorldExportJobs request with the returned nextToken value. This value can be between 1 and 100. If this parameter is not used, then ListWorldExportJobs returns up to 100 results and a nextToken value if applicable. . Defaults to None.
        filters(List, optional): Optional filters to limit results. You can use generationJobId and templateId. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.world.export_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.world.export_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="list_world_export_jobs",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "filters": filters,
        },
    )
