"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, job: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the specified simulation job.

    Args:
        job(str): The simulation job ARN to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.job.init.cancel(ctx, job=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.job.init.cancel job=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="cancel_simulation_job",
        op_kwargs={"job": job},
    )


async def create(
    hub,
    ctx,
    max_job_duration_in_seconds: int,
    iam_role: str,
    client_request_token: str = None,
    output_location: Dict = None,
    logging_config: Dict = None,
    failure_behavior: str = None,
    robot_applications: List = None,
    simulation_applications: List = None,
    data_sources: List = None,
    tags: Dict = None,
    vpc_config: Dict = None,
    compute: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a simulation job.  After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.

    Args:
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        output_location(Dict, optional): Location for output files generated by the simulation job. Defaults to None.
        logging_config(Dict, optional): The logging configuration. Defaults to None.
        max_job_duration_in_seconds(int): The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When maxJobDurationInSeconds is reached, the simulation job will status will transition to Completed.
        iam_role(str): The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. .
        failure_behavior(str, optional): The failure behavior the simulation job.  Continue  Restart the simulation job in the same host instance.  Fail  Stop the simulation job and terminate the instance.  . Defaults to None.
        robot_applications(List, optional): The robot application to use in the simulation job. Defaults to None.
        simulation_applications(List, optional): The simulation application to use in the simulation job. Defaults to None.
        data_sources(List, optional): Specify data sources to mount read-only files from S3 into your simulation. These files are available under /opt/robomaker/datasources/data_source_name.   There is a limit of 100 files and a combined size of 25GB for all DataSourceConfig objects.  . Defaults to None.
        tags(Dict, optional): A map that contains tag keys and tag values that are attached to the simulation job. Defaults to None.
        vpc_config(Dict, optional): If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and one subnet ID. . Defaults to None.
        compute(Dict, optional): Compute information for the simulation job. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.job.init.create(
                ctx, max_job_duration_in_seconds=value, iam_role=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.job.init.create max_job_duration_in_seconds=value, iam_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="create_simulation_job",
        op_kwargs={
            "clientRequestToken": client_request_token,
            "outputLocation": output_location,
            "loggingConfig": logging_config,
            "maxJobDurationInSeconds": max_job_duration_in_seconds,
            "iamRole": iam_role,
            "failureBehavior": failure_behavior,
            "robotApplications": robot_applications,
            "simulationApplications": simulation_applications,
            "dataSources": data_sources,
            "tags": tags,
            "vpcConfig": vpc_config,
            "compute": compute,
        },
    )


async def describe(hub, ctx, job: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a simulation job.

    Args:
        job(str): The Amazon Resource Name (ARN) of the simulation job to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.job.init.describe(ctx, job=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.job.init.describe job=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="describe_simulation_job",
        op_kwargs={"job": job},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.

    Args:
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object's nextToken parameter value is set to a token. To retrieve the next set of results, call ListSimulationJobs again and assign that token to the request object's nextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. . Defaults to None.
        max_results(int, optional): When this parameter is used, ListSimulationJobs only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListSimulationJobs request with the returned nextToken value. This value can be between 1 and 1000. If this parameter is not used, then ListSimulationJobs returns up to 1000 results and a nextToken value if applicable. . Defaults to None.
        filters(List, optional): Optional filters to limit results. The filter names status and simulationApplicationName and robotApplicationName are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status Preparing or the status Running. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.job.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.job.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="list_simulation_jobs",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "filters": filters,
        },
    )


async def restart(hub, ctx, job: str) -> Dict:
    r"""
    **Autogenerated function**

    Restarts a running simulation job.

    Args:
        job(str): The Amazon Resource Name (ARN) of the simulation job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.job.init.restart(ctx, job=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.job.init.restart job=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="restart_simulation_job",
        op_kwargs={"job": job},
    )
