"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, batch: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active simulation jobs created as part of the batch.

    Args:
        batch(str): The id of the batch to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.job.batch.cancel(ctx, batch=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.job.batch.cancel batch=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="cancel_simulation_job_batch",
        op_kwargs={"batch": batch},
    )


async def describe(hub, ctx, batch: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a simulation job batch.

    Args:
        batch(str): The id of the batch to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.job.batch.describe(ctx, batch=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.job.batch.describe batch=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="describe_simulation_job_batch",
        op_kwargs={"batch": batch},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch jobs.

    Args:
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object's nextToken parameter value is set to a token. To retrieve the next set of results, call ListSimulationJobBatches again and assign that token to the request object's nextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. . Defaults to None.
        max_results(int, optional): When this parameter is used, ListSimulationJobBatches only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListSimulationJobBatches request with the returned nextToken value. . Defaults to None.
        filters(List, optional): Optional filters to limit results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.job.batch.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.job.batch.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="list_simulation_job_batches",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "filters": filters,
        },
    )


async def start(
    hub,
    ctx,
    create_simulation_job_requests: List,
    client_request_token: str = None,
    batch_policy: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a new simulation job batch. The batch is defined using one or more SimulationJobRequest objects.

    Args:
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        batch_policy(Dict, optional): The batch policy. Defaults to None.
        create_simulation_job_requests(List): A list of simulation job requests to create in the batch.
        tags(Dict, optional): A map that contains tag keys and tag values that are attached to the deployment job batch. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.job.batch.start(
                ctx, create_simulation_job_requests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.job.batch.start create_simulation_job_requests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="start_simulation_job_batch",
        op_kwargs={
            "clientRequestToken": client_request_token,
            "batchPolicy": batch_policy,
            "createSimulationJobRequests": create_simulation_job_requests,
            "tags": tags,
        },
    )
