"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, application: str, current_revision_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a simulation application with a specific revision id.

    Args:
        application(str): The application information for the simulation application.
        current_revision_id(str, optional): The current revision id for the simulation application. If you provide a value and it matches the latest revision ID, a new version will be created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.application.version.create(
                ctx, application=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.application.version.create application=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="create_simulation_application_version",
        op_kwargs={
            "application": application,
            "currentRevisionId": current_revision_id,
        },
    )
