"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    sources: List,
    simulation_software_suite: Dict,
    robot_software_suite: Dict,
    rendering_engine: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a simulation application.

    Args:
        name(str): The name of the simulation application.
        sources(List): The sources of the simulation application.
        simulation_software_suite(Dict): The simulation software suite used by the simulation application.
        robot_software_suite(Dict): The robot software suite (ROS distribution) used by the simulation application.
        rendering_engine(Dict, optional): The rendering engine for the simulation application. Defaults to None.
        tags(Dict, optional): A map that contains tag keys and tag values that are attached to the simulation application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.application.init.create(
                ctx,
                name=value,
                sources=value,
                simulation_software_suite=value,
                robot_software_suite=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.application.init.create name=value, sources=value, simulation_software_suite=value, robot_software_suite=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="create_simulation_application",
        op_kwargs={
            "name": name,
            "sources": sources,
            "simulationSoftwareSuite": simulation_software_suite,
            "robotSoftwareSuite": robot_software_suite,
            "renderingEngine": rendering_engine,
            "tags": tags,
        },
    )


async def delete(hub, ctx, application: str, application_version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a simulation application.

    Args:
        application(str): The application information for the simulation application to delete.
        application_version(str, optional): The version of the simulation application to delete. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.application.init.delete(
                ctx, application=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.application.init.delete application=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="delete_simulation_application",
        op_kwargs={
            "application": application,
            "applicationVersion": application_version,
        },
    )


async def describe(hub, ctx, application: str, application_version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes a simulation application.

    Args:
        application(str): The application information for the simulation application.
        application_version(str, optional): The version of the simulation application to describe. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.application.init.describe(
                ctx, application=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.application.init.describe application=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="describe_simulation_application",
        op_kwargs={
            "application": application,
            "applicationVersion": application_version,
        },
    )


async def list_all(
    hub,
    ctx,
    version_qualifier: str = None,
    next_token: str = None,
    max_results: int = None,
    filters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation applications.

    Args:
        version_qualifier(str, optional): The version qualifier of the simulation application. Defaults to None.
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object's nextToken parameter value is set to a token. To retrieve the next set of results, call ListSimulationApplications again and assign that token to the request object's nextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. . Defaults to None.
        max_results(int, optional): When this parameter is used, ListSimulationApplications only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListSimulationApplications request with the returned nextToken value. This value can be between 1 and 100. If this parameter is not used, then ListSimulationApplications returns up to 100 results and a nextToken value if applicable. . Defaults to None.
        filters(List, optional): Optional list of filters to limit results. The filter name name is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.application.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.application.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="list_simulation_applications",
        op_kwargs={
            "versionQualifier": version_qualifier,
            "nextToken": next_token,
            "maxResults": max_results,
            "filters": filters,
        },
    )


async def update(
    hub,
    ctx,
    application: str,
    sources: List,
    simulation_software_suite: Dict,
    robot_software_suite: Dict,
    rendering_engine: Dict = None,
    current_revision_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a simulation application.

    Args:
        application(str): The application information for the simulation application.
        sources(List): The sources of the simulation application.
        simulation_software_suite(Dict): The simulation software suite used by the simulation application.
        robot_software_suite(Dict): Information about the robot software suite (ROS distribution).
        rendering_engine(Dict, optional): The rendering engine for the simulation application. Defaults to None.
        current_revision_id(str, optional): The revision id for the robot application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.simulation.application.init.update(
                ctx,
                application=value,
                sources=value,
                simulation_software_suite=value,
                robot_software_suite=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.simulation.application.init.update application=value, sources=value, simulation_software_suite=value, robot_software_suite=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="update_simulation_application",
        op_kwargs={
            "application": application,
            "sources": sources,
            "simulationSoftwareSuite": simulation_software_suite,
            "robotSoftwareSuite": robot_software_suite,
            "renderingEngine": rendering_engine,
            "currentRevisionId": current_revision_id,
        },
    )
