"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, name: str, architecture: str, greengrass_group_id: str, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a robot.

    Args:
        name(str): The name for the robot.
        architecture(str): The target architecture of the robot.
        greengrass_group_id(str): The Greengrass group id.
        tags(Dict, optional): A map that contains tag keys and tag values that are attached to the robot. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.robot.init.create(
                ctx, name=value, architecture=value, greengrass_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.robot.init.create name=value, architecture=value, greengrass_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="create_robot",
        op_kwargs={
            "name": name,
            "architecture": architecture,
            "greengrassGroupId": greengrass_group_id,
            "tags": tags,
        },
    )


async def delete(hub, ctx, robot: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a robot.

    Args:
        robot(str): The Amazon Resource Name (ARN) of the robot.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.robot.init.delete(ctx, robot=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.robot.init.delete robot=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="delete_robot",
        op_kwargs={"robot": robot},
    )


async def deregister(hub, ctx, fleet: str, robot: str) -> Dict:
    r"""
    **Autogenerated function**

    Deregisters a robot.

    Args:
        fleet(str): The Amazon Resource Name (ARN) of the fleet.
        robot(str): The Amazon Resource Name (ARN) of the robot.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.robot.init.deregister(ctx, fleet=value, robot=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.robot.init.deregister fleet=value, robot=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="deregister_robot",
        op_kwargs={"fleet": fleet, "robot": robot},
    )


async def describe(hub, ctx, robot: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a robot.

    Args:
        robot(str): The Amazon Resource Name (ARN) of the robot to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.robot.init.describe(ctx, robot=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.robot.init.describe robot=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="describe_robot",
        op_kwargs={"robot": robot},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of robots. You can optionally provide filters to retrieve specific robots.

    Args:
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object's nextToken parameter value is set to a token. To retrieve the next set of results, call ListRobots again and assign that token to the request object's nextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. . Defaults to None.
        max_results(int, optional): When this parameter is used, ListRobots only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListRobots request with the returned nextToken value. This value can be between 1 and 200. If this parameter is not used, then ListRobots returns up to 200 results and a nextToken value if applicable. . Defaults to None.
        filters(List, optional): Optional filters to limit results. The filter names status and fleetName are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status Registered or the status Available. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.robot.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.robot.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="list_robots",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "filters": filters,
        },
    )


async def register(hub, ctx, fleet: str, robot: str) -> Dict:
    r"""
    **Autogenerated function**

    Registers a robot with a fleet.

    Args:
        fleet(str): The Amazon Resource Name (ARN) of the fleet.
        robot(str): The Amazon Resource Name (ARN) of the robot.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.robot.init.register(ctx, fleet=value, robot=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.robot.init.register fleet=value, robot=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="register_robot",
        op_kwargs={"fleet": fleet, "robot": robot},
    )
