"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, name: str, sources: List, robot_software_suite: Dict, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a robot application.

    Args:
        name(str): The name of the robot application.
        sources(List): The sources of the robot application.
        robot_software_suite(Dict): The robot software suite (ROS distribuition) used by the robot application.
        tags(Dict, optional): A map that contains tag keys and tag values that are attached to the robot application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.robot.application.init.create(
                ctx, name=value, sources=value, robot_software_suite=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.robot.application.init.create name=value, sources=value, robot_software_suite=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="create_robot_application",
        op_kwargs={
            "name": name,
            "sources": sources,
            "robotSoftwareSuite": robot_software_suite,
            "tags": tags,
        },
    )


async def delete(hub, ctx, application: str, application_version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a robot application.

    Args:
        application(str): The Amazon Resource Name (ARN) of the the robot application.
        application_version(str, optional): The version of the robot application to delete. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.robot.application.init.delete(ctx, application=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.robot.application.init.delete application=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="delete_robot_application",
        op_kwargs={
            "application": application,
            "applicationVersion": application_version,
        },
    )


async def describe(hub, ctx, application: str, application_version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes a robot application.

    Args:
        application(str): The Amazon Resource Name (ARN) of the robot application.
        application_version(str, optional): The version of the robot application to describe. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.robot.application.init.describe(
                ctx, application=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.robot.application.init.describe application=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="describe_robot_application",
        op_kwargs={
            "application": application,
            "applicationVersion": application_version,
        },
    )


async def list_all(
    hub,
    ctx,
    version_qualifier: str = None,
    next_token: str = None,
    max_results: int = None,
    filters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.

    Args:
        version_qualifier(str, optional): The version qualifier of the robot application. Defaults to None.
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object's nextToken parameter value is set to a token. To retrieve the next set of results, call ListRobotApplications again and assign that token to the request object's nextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. . Defaults to None.
        max_results(int, optional): When this parameter is used, ListRobotApplications only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListRobotApplications request with the returned nextToken value. This value can be between 1 and 100. If this parameter is not used, then ListRobotApplications returns up to 100 results and a nextToken value if applicable. . Defaults to None.
        filters(List, optional): Optional filters to limit results. The filter name name is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.robot.application.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.robot.application.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="list_robot_applications",
        op_kwargs={
            "versionQualifier": version_qualifier,
            "nextToken": next_token,
            "maxResults": max_results,
            "filters": filters,
        },
    )


async def update(
    hub,
    ctx,
    application: str,
    sources: List,
    robot_software_suite: Dict,
    current_revision_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a robot application.

    Args:
        application(str): The application information for the robot application.
        sources(List): The sources of the robot application.
        robot_software_suite(Dict): The robot software suite (ROS distribution) used by the robot application.
        current_revision_id(str, optional): The revision id for the robot application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.robot.application.init.update(
                ctx, application=value, sources=value, robot_software_suite=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.robot.application.init.update application=value, sources=value, robot_software_suite=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="update_robot_application",
        op_kwargs={
            "application": application,
            "sources": sources,
            "robotSoftwareSuite": robot_software_suite,
            "currentRevisionId": current_revision_id,
        },
    )
