"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, name: str, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a fleet, a logical group of robots running the same robot application.

    Args:
        name(str): The name of the fleet.
        tags(Dict, optional): A map that contains tag keys and tag values that are attached to the fleet. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.fleet.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.fleet.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="create_fleet",
        op_kwargs={"name": name, "tags": tags},
    )


async def delete(hub, ctx, fleet: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a fleet.

    Args:
        fleet(str): The Amazon Resource Name (ARN) of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.fleet.delete(ctx, fleet=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.fleet.delete fleet=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="delete_fleet",
        op_kwargs={"fleet": fleet},
    )


async def describe(hub, ctx, fleet: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a fleet.

    Args:
        fleet(str): The Amazon Resource Name (ARN) of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.fleet.describe(ctx, fleet=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.fleet.describe fleet=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="describe_fleet",
        op_kwargs={"fleet": fleet},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.

    Args:
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object's nextToken parameter value is set to a token. To retrieve the next set of results, call ListFleets again and assign that token to the request object's nextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null.   This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.
        max_results(int, optional): When this parameter is used, ListFleets only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListFleets request with the returned nextToken value. This value can be between 1 and 200. If this parameter is not used, then ListFleets returns up to 200 results and a nextToken value if applicable. . Defaults to None.
        filters(List, optional): Optional filters to limit results. The filter name name is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.fleet.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.fleet.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="list_fleets",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "filters": filters,
        },
    )
