"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, job: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the specified deployment job.

    Args:
        job(str): The deployment job ARN to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.deployment_job.cancel(ctx, job=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.deployment_job.cancel job=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="cancel_deployment_job",
        op_kwargs={"job": job},
    )


async def create(
    hub,
    ctx,
    client_request_token: str,
    fleet: str,
    deployment_application_configs: List,
    deployment_config: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deploys a specific version of a robot application to robots in a fleet. The robot application must have a numbered applicationVersion for consistency reasons. To create a new version, use CreateRobotApplicationVersion or see Creating a Robot Application Version.   After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.

    Args:
        deployment_config(Dict, optional): The requested deployment configuration. Defaults to None.
        client_request_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
        fleet(str): The Amazon Resource Name (ARN) of the fleet to deploy.
        deployment_application_configs(List): The deployment application configuration.
        tags(Dict, optional): A map that contains tag keys and tag values that are attached to the deployment job. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.deployment_job.create(
                ctx, client_request_token=value, fleet=value, deployment_application_configs=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.deployment_job.create client_request_token=value, fleet=value, deployment_application_configs=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="create_deployment_job",
        op_kwargs={
            "deploymentConfig": deployment_config,
            "clientRequestToken": client_request_token,
            "fleet": fleet,
            "deploymentApplicationConfigs": deployment_application_configs,
            "tags": tags,
        },
    )


async def describe(hub, ctx, job: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a deployment job.

    Args:
        job(str): The Amazon Resource Name (ARN) of the deployment job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.deployment_job.describe(ctx, job=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.deployment_job.describe job=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="describe_deployment_job",
        op_kwargs={"job": job},
    )


async def list_all(
    hub, ctx, filters: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment jobs.

    Args:
        filters(List, optional): Optional filters to limit results. The filter names status and fleetName are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status InProgress or the status Pending. Defaults to None.
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object's nextToken parameter value is set to a token. To retrieve the next set of results, call ListDeploymentJobs again and assign that token to the request object's nextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. . Defaults to None.
        max_results(int, optional): When this parameter is used, ListDeploymentJobs only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListDeploymentJobs request with the returned nextToken value. This value can be between 1 and 200. If this parameter is not used, then ListDeploymentJobs returns up to 200 results and a nextToken value if applicable. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.deployment_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.deployment_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="list_deployment_jobs",
        op_kwargs={
            "filters": filters,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def sync(hub, ctx, client_request_token: str, fleet: str) -> Dict:
    r"""
    **Autogenerated function**

    Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.

    Args:
        client_request_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
        fleet(str): The target fleet for the synchronization.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.deployment_job.sync(
                ctx, client_request_token=value, fleet=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.deployment_job.sync client_request_token=value, fleet=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="sync_deployment_job",
        op_kwargs={"clientRequestToken": client_request_token, "fleet": fleet},
    )
