"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, worlds: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more worlds in a batch operation.

    Args:
        worlds(List): A list of Amazon Resource Names (arns) that correspond to worlds to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.robomaker.delete_world.batch(ctx, worlds=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.robomaker.delete_world.batch worlds=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="robomaker",
        operation="batch_delete_worlds",
        op_kwargs={"worlds": worlds},
    )
