"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, key: str, pagination_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns all tag values for the specified key that are used in the specified AWS Region for the calling AWS account. This operation supports pagination, where the response can be sent in multiple pages. You should check the PaginationToken response parameter to determine if there are additional results available to return. Repeat the query, passing the PaginationToken response parameter value as an input to the next request until you recieve a null value. A null value for PaginationToken indicates that there are no more results waiting to be returned.

    Args:
        pagination_token(str, optional): Specifies a PaginationToken response value from a previous request to indicate that you want the next page of results. Leave this parameter empty in your initial request. Defaults to None.
        key(str): Specifies the tag key for which you want to list all existing values that are currently used in the specified AWS Region for the calling AWS account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resourcegroupstaggingapi.tag.value.get_all(ctx, key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resourcegroupstaggingapi.tag.value.get_all key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resourcegroupstaggingapi",
        operation="get_tag_values",
        op_kwargs={"PaginationToken": pagination_token, "Key": key},
    )
