"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    pagination_token: str = None,
    tag_filters: List = None,
    resources_per_page: int = None,
    tags_per_page: int = None,
    resource_type_filters: List = None,
    include_compliance_details: bool = None,
    exclude_compliant_resources: bool = None,
    resource_arn_list: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns all the tagged or previously tagged resources that are located in the specified Region for the AWS account. Depending on what information you want returned, you can also specify the following:    Filters that specify what tags and resource types you want returned. The response includes all tags that are associated with the requested resources.   Information about compliance with the account's effective tag policy. For more information on tag policies, see Tag Policies in the AWS Organizations User Guide.    This operation supports pagination, where the response can be sent in multiple pages. You should check the PaginationToken response parameter to determine if there are additional results available to return. Repeat the query, passing the PaginationToken response parameter value as an input to the next request until you recieve a null value. A null value for PaginationToken indicates that there are no more results waiting to be returned.

    Args:
        pagination_token(str, optional): Specifies a PaginationToken response value from a previous request to indicate that you want the next page of results. Leave this parameter empty in your initial request. Defaults to None.
        tag_filters(List, optional): Specifies a list of TagFilters (keys and values) to restrict the output to only those resources that have the specified tag and, if included, the specified value. Each TagFilter must contain a key with values optional. A request can include up to 50 keys, and each key can include up to 20 values.  Note the following when deciding how to use TagFilters:   If you don't specify a TagFilter, the response includes all resources that are currently tagged or ever had a tag. Resources that currently don't have tags are shown with an empty tag set, like this: "Tags": [].   If you specify more than one filter in a single request, the response returns only those resources that satisfy all filters.   If you specify a filter that contains more than one value for a key, the response returns resources that match any of the specified values for that key.   If you don't specify any values for a key, the response returns resources that are tagged with that key and any or no value. For example, for the following filters: filter1= {keyA,{value1}}, filter2={keyB,{value2,value3,value4}}, filter3= {keyC}:    GetResources({filter1}) returns resources tagged with key1=value1     GetResources({filter2}) returns resources tagged with key2=value2 or key2=value3 or key2=value4     GetResources({filter3}) returns resources tagged with any tag with the key key3, and with any or no value    GetResources({filter1,filter2,filter3}) returns resources tagged with (key1=value1) and (key2=value2 or key2=value3 or key2=value4) and (key3, any or no value)     . Defaults to None.
        resources_per_page(int, optional): Specifies the maximum number of results to be returned in each page. A query can return fewer than this maximum, even if there are more results still to return. You should always check the PaginationToken response value to see if there are more results. You can specify a minimum of 1 and a maximum value of 100. Defaults to None.
        tags_per_page(int, optional): AWS recommends using ResourcesPerPage instead of this parameter. A limit that restricts the number of tags (key and value pairs) returned by GetResources in paginated output. A resource with no tags is counted as having one tag (one key and value pair).  GetResources does not split a resource and its associated tags across pages. If the specified TagsPerPage would cause such a break, a PaginationToken is returned in place of the affected resource and its tags. Use that token in another request to get the remaining data. For example, if you specify a TagsPerPage of 100 and the account has 22 resources with 10 tags each (meaning that each resource has 10 key and value pairs), the output will consist of three pages. The first page displays the first 10 resources, each with its 10 tags. The second page displays the next 10 resources, each with its 10 tags. The third page displays the remaining 2 resources, each with its 10 tags. You can set TagsPerPage to a minimum of 100 items up to a maximum of 500 items. Defaults to None.
        resource_type_filters(List, optional): Specifies the resource types that you want included in the response. The format of each resource type is service[:resourceType]. For example, specifying a resource type of ec2 returns all Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of ec2:instance returns only EC2 instances.  The string for each service name and resource type is the same as that embedded in a resource's Amazon Resource Name (ARN). Consult the AWS General Reference for the following: For more information about ARNs, see Amazon Resource Names (ARNs) and AWS Service Namespaces. You can specify multiple resource types by using an array. The array can include up to 100 items. Note that the length constraint requirement applies to each resource type filter. . Defaults to None.
        include_compliance_details(bool, optional): Specifies whether to include details regarding the compliance with the effective tag policy. Set this to true to determine whether resources are compliant with the tag policy and to get details. Defaults to None.
        exclude_compliant_resources(bool, optional): Specifies whether to exclude resources that are compliant with the tag policy. Set this to true if you are interested in retrieving information on noncompliant resources only. You can use this parameter only if the IncludeComplianceDetails parameter is also set to true. Defaults to None.
        resource_arn_list(List, optional): Specifies a list of ARNs of resources for which you want to retrieve tag data. You can't specify both this parameter and any of the pagination parameters (ResourcesPerPage, TagsPerPage, PaginationToken) in the same request. If you specify both, you get an Invalid Parameter exception. If a resource specified by this parameter doesn't exist, it doesn't generate an error; it simply isn't included in the response. An ARN (Amazon Resource Name) uniquely identifies a resource. For more information, see Amazon Resource Names (ARNs) and AWS Service Namespaces in the AWS General Reference. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resourcegroupstaggingapi.resource.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resourcegroupstaggingapi.resource.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resourcegroupstaggingapi",
        operation="get_resources",
        op_kwargs={
            "PaginationToken": pagination_token,
            "TagFilters": tag_filters,
            "ResourcesPerPage": resources_per_page,
            "TagsPerPage": tags_per_page,
            "ResourceTypeFilters": resource_type_filters,
            "IncludeComplianceDetails": include_compliance_details,
            "ExcludeCompliantResources": exclude_compliant_resources,
            "ResourceARNList": resource_arn_list,
        },
    )


async def tag(hub, ctx, resource_arn_list: List, tags: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Applies one or more tags to the specified resources. Note the following:   Not all resources can have tags. For a list of services with resources that support tagging using this operation, see Services that support the Resource Groups Tagging API.   Each resource can have up to 50 tags. For other limits, see Tag Naming and Usage Conventions in the AWS General Reference.    You can only tag resources that are located in the specified AWS Region for the AWS account.   To add tags to a resource, you need the necessary permissions for the service that the resource belongs to as well as permissions for adding tags. For more information, see the documentation for each service.    Do not store personally identifiable information (PII) or other confidential or sensitive information in tags. We use tags to provide you with billing and administration services. Tags are not intended to be used for private or sensitive data.

    Args:
        resource_arn_list(List): Specifies the list of ARNs of the resources that you want to apply tags to. An ARN (Amazon Resource Name) uniquely identifies a resource. For more information, see Amazon Resource Names (ARNs) and AWS Service Namespaces in the AWS General Reference.
        tags(Dict): Specifies a list of tags that you want to add to the specified resources. A tag consists of a key and a value that you define.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resourcegroupstaggingapi.resource.tag(
                ctx, resource_arn_list=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resourcegroupstaggingapi.resource.tag resource_arn_list=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resourcegroupstaggingapi",
        operation="tag_resources",
        op_kwargs={"ResourceARNList": resource_arn_list, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn_list: List, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified tags from the specified resources. When you specify a tag key, the action removes both that key and its associated value. The operation succeeds even if you attempt to remove tags from a resource that were already removed. Note the following:   To remove tags from a resource, you need the necessary permissions for the service that the resource belongs to as well as permissions for removing tags. For more information, see the documentation for the service whose resource you want to untag.   You can only tag resources that are located in the specified AWS Region for the calling AWS account.

    Args:
        resource_arn_list(List): Specifies a list of ARNs of the resources that you want to remove tags from. An ARN (Amazon Resource Name) uniquely identifies a resource. For more information, see Amazon Resource Names (ARNs) and AWS Service Namespaces in the AWS General Reference.
        tag_keys(List): Specifies a list of tag keys that you want to remove from the specified resources.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resourcegroupstaggingapi.resource.untag(
                ctx, resource_arn_list=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resourcegroupstaggingapi.resource.untag resource_arn_list=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resourcegroupstaggingapi",
        operation="untag_resources",
        op_kwargs={"ResourceARNList": resource_arn_list, "TagKeys": tag_keys},
    )
