"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Describes the status of the StartReportCreation operation.  You can call this operation only from the organization's management account and from the us-east-1 Region.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resourcegroupstaggingapi.report_creation.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resourcegroupstaggingapi.report_creation.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resourcegroupstaggingapi",
        operation="describe_report_creation",
        op_kwargs={},
    )


async def start(hub, ctx, s3_bucket: str) -> Dict:
    r"""
    **Autogenerated function**

    Generates a report that lists all tagged resources in the accounts across your organization and tells whether each resource is compliant with the effective tag policy. Compliance data is refreshed daily. The report is generated asynchronously. The generated report is saved to the following location:  s3://example-bucket/AwsTagPolicies/o-exampleorgid/YYYY-MM-ddTHH:mm:ssZ/report.csv  You can call this operation only from the organization's management account and from the us-east-1 Region.

    Args:
        s3_bucket(str): The name of the Amazon S3 bucket where the report will be stored; for example:  awsexamplebucket  For more information on S3 bucket requirements, including an example bucket policy, see the example S3 bucket policy on this page.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resourcegroupstaggingapi.report_creation.start(
                ctx, s3_bucket=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resourcegroupstaggingapi.report_creation.start s3_bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resourcegroupstaggingapi",
        operation="start_report_creation",
        op_kwargs={"S3Bucket": s3_bucket},
    )
