"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    target_id_filters: List = None,
    region_filters: List = None,
    resource_type_filters: List = None,
    tag_key_filters: List = None,
    group_by: List = None,
    max_results: int = None,
    pagination_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a table that shows counts of resources that are noncompliant with their tag policies. For more information on tag policies, see Tag Policies in the AWS Organizations User Guide.  You can call this operation only from the organization's management account and from the us-east-1 Region. This operation supports pagination, where the response can be sent in multiple pages. You should check the PaginationToken response parameter to determine if there are additional results available to return. Repeat the query, passing the PaginationToken response parameter value as an input to the next request until you recieve a null value. A null value for PaginationToken indicates that there are no more results waiting to be returned.

    Args:
        target_id_filters(List, optional): Specifies target identifiers (usually, specific account IDs) to limit the output by. If you use this parameter, the count of returned noncompliant resources includes only resources with the specified target IDs. Defaults to None.
        region_filters(List, optional): Specifies a list of AWS Regions to limit the output by. If you use this parameter, the count of returned noncompliant resources includes only resources in the specified Regions. Defaults to None.
        resource_type_filters(List, optional): Specifies that you want the response to include information for only resources of the specified types. The format of each resource type is service[:resourceType]. For example, specifying a resource type of ec2 returns all Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of ec2:instance returns only EC2 instances.  The string for each service name and resource type is the same as that embedded in a resource's Amazon Resource Name (ARN). Consult the AWS General Reference for the following:   For a list of service name strings, see AWS Service Namespaces.   For resource type strings, see Example ARNs.   For more information about ARNs, see Amazon Resource Names (ARNs) and AWS Service Namespaces.   You can specify multiple resource types by using a comma separated array. The array can include up to 100 items. Note that the length constraint requirement applies to each resource type filter. . Defaults to None.
        tag_key_filters(List, optional): Specifies that you want the response to include information for only resources that have tags with the specified tag keys. If you use this parameter, the count of returned noncompliant resources includes only resources that have the specified tag keys. Defaults to None.
        group_by(List, optional): Specifies a list of attributes to group the counts of noncompliant resources by. If supplied, the counts are sorted by those attributes. Defaults to None.
        max_results(int, optional): Specifies the maximum number of results to be returned in each page. A query can return fewer than this maximum, even if there are more results still to return. You should always check the PaginationToken response value to see if there are more results. You can specify a minimum of 1 and a maximum value of 100. Defaults to None.
        pagination_token(str, optional): Specifies a PaginationToken response value from a previous request to indicate that you want the next page of results. Leave this parameter empty in your initial request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resourcegroupstaggingapi.compliance_summary.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resourcegroupstaggingapi.compliance_summary.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resourcegroupstaggingapi",
        operation="get_compliance_summary",
        op_kwargs={
            "TargetIdFilters": target_id_filters,
            "RegionFilters": region_filters,
            "ResourceTypeFilters": resource_type_filters,
            "TagKeyFilters": tag_key_filters,
            "GroupBy": group_by,
            "MaxResults": max_results,
            "PaginationToken": pagination_token,
        },
    )
