"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def group(hub, ctx, group: str, resource_arns: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds the specified resources to the specified group.  Minimum permissions  To run this command, you must have the following permissions:    resource-groups:GroupResources

    Args:
        group(str): The name or the ARN of the resource group to add resources to.
        resource_arns(List): The list of ARNs for resources to be added to the group. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.resource.group(
                ctx, group=value, resource_arns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.resource.group group=value, resource_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="group_resources",
        op_kwargs={"Group": group, "ResourceArns": resource_arns},
    )


async def search(
    hub, ctx, resource_query: Dict, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of AWS resource identifiers that matches the specified query. The query uses the same format as a resource query in a CreateGroup or UpdateGroupQuery operation.  Minimum permissions  To run this command, you must have the following permissions:    resource-groups:SearchResources     cloudformation:DescribeStacks     cloudformation:ListStackResources     tag:GetResources

    Args:
        resource_query(Dict): The search query, using the same formats that are supported for resource group definition. For more information, see CreateGroup.
        max_results(int, optional): The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the NextToken response element is present and has a value (is not null). Include that value as the NextToken request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check NextToken after every operation to ensure that you receive all of the results. Defaults to None.
        next_token(str, optional): The parameter for receiving additional results if you receive a NextToken response in a previous request. A NextToken response indicates that more output is available. Set this parameter to the value provided by a previous call's NextToken response to indicate where the output should continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.resource.search(ctx, resource_query=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.resource.search resource_query=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="search_resources",
        op_kwargs={
            "ResourceQuery": resource_query,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def ungroup(hub, ctx, group: str, resource_arns: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified resources from the specified group.  Minimum permissions  To run this command, you must have the following permissions:    resource-groups:UngroupResources

    Args:
        group(str): The name or the ARN of the resource group from which to remove the resources.
        resource_arns(List): The ARNs of the resources to be removed from the group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.resource.ungroup(
                ctx, group=value, resource_arns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.resource.ungroup group=value, resource_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="ungroup_resources",
        op_kwargs={"Group": group, "ResourceArns": resource_arns},
    )
