"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, arn: str, tags: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds tags to a resource group with the specified ARN. Existing tags on a resource group are not changed if they are not specified in the request parameters.  Do not store personally identifiable information (PII) or other confidential or sensitive information in tags. We use tags to provide you with billing and administration services. Tags are not intended to be used for private or sensitive data.   Minimum permissions  To run this command, you must have the following permissions:    resource-groups:Tag

    Args:
        arn(str): The ARN of the resource group to which to add tags.
        tags(Dict): The tags to add to the specified resource group. A tag is a string-to-string map of key-value pairs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.init.tag(ctx, arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.init.tag arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="tag",
        op_kwargs={"Arn": arn, "Tags": tags},
    )


async def untag(hub, ctx, arn: str, keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes tags from a specified resource group.  Minimum permissions  To run this command, you must have the following permissions:    resource-groups:Untag

    Args:
        arn(str): The ARN of the resource group from which to remove tags. The command removed both the specified keys and any values associated with those keys.
        keys(List): The keys of the tags to be removed.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.init.untag(ctx, arn=value, keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.init.untag arn=value, keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="untag",
        op_kwargs={"Arn": arn, "Keys": keys},
    )
